#include <bits/stdc++.h>
using namespace std;

struct Fenwick {
    int n;
    vector<long long> f;
    Fenwick(int n) : n(n), f(n + 1, 0) {}

    void add(int i, long long v) {
        for (; i <= n; i += i & -i) f[i] += v;
    }

    long long sum(int i) {
        long long s = 0;
        for (; i > 0; i -= i & -i) s += f[i];
        return s;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;

    vector<int> a(N + 1);
    for (int i = 1; i <= N; i++) cin >> a[i];

    vector<set<int>> pos(N + 1);
    for (int i = 1; i <= N; i++) {
        pos[a[i]].insert(i);
    }

    Fenwick fw(N);

    auto add_value = [&](int v) {
        if (!pos[v].empty()) {
            int last = *pos[v].rbegin();
            fw.add(last, 1LL * v * pos[v].size());
        }
    };

    auto remove_value = [&](int v) {
        if (!pos[v].empty()) {
            int last = *pos[v].rbegin();
            fw.add(last, -1LL * v * pos[v].size());
        }
    };

    for (int v = 1; v <= N; v++) {
        add_value(v);
    }

    while (Q--) {
        int t;
        cin >> t;

        if (t == 1) {
            int k;
            cin >> k;
            cout << fw.sum(k) << '\n';
        } else {
            int x, y;
            cin >> x >> y;

            int old = a[x];
            if (old == y) continue;

            remove_value(old);
            pos[old].erase(x);
            add_value(old);

            remove_value(y);
            pos[y].insert(x);
            add_value(y);

            a[x] = y;
        }
    }

    return 0;
}